/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.util.concurrent.CountDownLatch;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyUnicode;
import org.python.util.PythonInterpreter;

public class InterpreterTest
extends TestCase {
    public void testBasicEval() throws Exception {
        PyDictionary pyDictionary = new PyDictionary();
        pyDictionary.__setitem__(new PyUnicode("one"), (PyObject)new PyUnicode("two"));
        PythonInterpreter.initialize(System.getProperties(), null, new String[0]);
        PythonInterpreter pythonInterpreter = new PythonInterpreter();
        PyObject pyObject = pythonInterpreter.eval("{u'one': u'two'}");
        InterpreterTest.assertEquals((Object)pyDictionary, (Object)pyObject);
    }

    public void testMultipleThreads() {
        final CountDownLatch countDownLatch = new CountDownLatch(10);
        for (int i = 0; i < 10; ++i) {
            new Thread(){

                public void run() {
                    PythonInterpreter pythonInterpreter = new PythonInterpreter();
                    pythonInterpreter.exec("import sys");
                    pythonInterpreter.set("a", new PyInteger(41));
                    int n = Py.tojava(pythonInterpreter.get("a"), Integer.class);
                    Assert.assertEquals((int)41, (int)n);
                    pythonInterpreter.exec("x = 'hello ' + 'goodbye'");
                    Assert.assertEquals((String)"hello goodbye", (String)Py.tojava(pythonInterpreter.get("x"), String.class));
                    countDownLatch.countDown();
                }
            }.start();
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Interpreters in multiple threads test interrupted, bailing");
        }
    }

    public void testCallInstancesFromJava() {
        PythonInterpreter pythonInterpreter = new PythonInterpreter();
        pythonInterpreter.exec("class Blah(object):\n    def __init__(self, val):\n        self.val = val\n    def incval(self):\n        self.val += 1\n        return self.val");
        PyObject pyObject = pythonInterpreter.get("Blah");
        int n = 42;
        PyObject pyObject2 = pyObject.__call__(new PyInteger(n));
        for (int i = 0; i < 4; ++i) {
            InterpreterTest.assertEquals((Object)(++n), (Object)pyObject2.invoke("incval").__tojava__(Integer.class));
        }
    }
}

